/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class ReferenceHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof ReferenceSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final Schema referredSchema = ((ReferenceSchema) schema).getReferredSchema();
    return handlerManager.handle(referredSchema, parsingContext);
  }
}
