/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class DefaultRestConnection
implements RestConnection {
    private final HttpClient httpClient;
    private final HttpRequestOptions httpRequestOptions;
    private final String baseUri;

    public DefaultRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri) {
        this.httpClient = httpClient;
        this.httpRequestOptions = httpRequestOptions;
        this.baseUri = baseUri;
    }

    private HttpClient getHttpClient() {
        return this.httpClient;
    }

    private HttpRequestOptions getHttpRequestOptions() {
        return this.httpRequestOptions;
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request) {
        return this.getHttpClient().sendAsync(this.beforeRequest(request), this.getHttpRequestOptions());
    }

    @Override
    public HttpResponse send(HttpRequest request) throws IOException, TimeoutException {
        return this.getHttpClient().send(this.beforeRequest(request), this.getHttpRequestOptions());
    }

    @Override
    public ConnectionValidationResult validate(HttpRequest request, Function<HttpResponse, ConnectionValidationResult> whenComplete, Function<Exception, ConnectionValidationResult> onError) {
        try {
            return whenComplete.apply(this.getHttpClient().send(this.beforeRequest(request), this.getHttpRequestOptions()));
        }
        catch (Exception e) {
            return onError.apply(e);
        }
    }

    private HttpRequest beforeRequest(HttpRequest request) {
        HttpRequestBuilder httpRequestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(request.getMethod()).protocol(request.getProtocol()).uri(request.getUri()).queryParams(request.getQueryParams()).headers(request.getHeaders())).entity(request.getEntity());
        this.authenticate(httpRequestBuilder);
        return httpRequestBuilder.build();
    }

    protected void authenticate(HttpRequestBuilder httpRequestBuilder) {
    }
}

