/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.sdk.api.annotation.param.RefName;

public abstract class RestConnectionProvider<C extends RestConnection>
implements CachedConnectionProvider<C>,
Initialisable,
Startable,
Stoppable {
    static final String CLIENT_NAME_PATTERN = "rest.connector.%s";
    @RefName
    private String configName;
    @Inject
    protected HttpService httpService;
    private HttpClient httpClient;
    private HttpAuthentication authentication;

    public abstract String getBaseUri();

    public final C connect() throws ConnectionException {
        try {
            return this.createConnection(this.httpClient, this.getHttpRequestOptions());
        }
        catch (Exception e) {
            throw new ConnectionException("Could not create connection", (Throwable)e);
        }
    }

    protected abstract C createConnection(HttpClient var1, HttpRequestOptions var2);

    public final void disconnect(C connection) {
    }

    public void initialise() throws InitialisationException {
        this.authentication = this.buildAuthentication();
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication);
        }
    }

    public void start() {
        this.startHttpClient();
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    private void startHttpClient() {
        HttpClientConfiguration.Builder configuration = new HttpClientConfiguration.Builder().setName(String.format(CLIENT_NAME_PATTERN, this.configName));
        this.configureClient(configuration);
        this.httpClient = this.httpService.getClientFactory().create(configuration.build());
        this.httpClient.start();
    }

    protected void configureClient(HttpClientConfiguration.Builder httpConfiguration) {
    }

    protected HttpAuthentication buildAuthentication() {
        return null;
    }

    protected Optional<Integer> getResponseTimeout() {
        return Optional.empty();
    }

    protected Optional<Boolean> isFollowsRedirect() {
        return Optional.empty();
    }

    private HttpRequestOptions getHttpRequestOptions() {
        HttpRequestOptionsBuilder httpRequestOptionsBuilder = HttpRequestOptions.builder().authentication(this.authentication);
        this.getResponseTimeout().ifPresent(responseTimeout -> httpRequestOptionsBuilder.responseTimeout(responseTimeout.intValue()));
        this.isFollowsRedirect().ifPresent(followsRedirect -> httpRequestOptionsBuilder.followsRedirect(followsRedirect.booleanValue()));
        return httpRequestOptionsBuilder.build();
    }
}

