/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.oauth;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OAuthRestConnection
extends DefaultRestConnection {
    private final OAuthState oauthState;
    private final String resourceOwnerId;

    public OAuthRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri, OAuthState oauthState, String resourceOwnerId) {
        super(httpClient, OAuthRestConnection.assertNoAuthenticationProvided(httpRequestOptions), baseUri);
        Preconditions.checkArgument((resourceOwnerId != null ? 1 : 0) != 0, (String)"resourceOwnerId cannot be null");
        this.resourceOwnerId = resourceOwnerId;
        Preconditions.checkArgument((oauthState != null ? 1 : 0) != 0, (String)"oauthState cannot be null");
        this.oauthState = oauthState;
    }

    private static HttpRequestOptions assertNoAuthenticationProvided(HttpRequestOptions httpRequestOptions) {
        if (httpRequestOptions.getAuthentication().isPresent()) {
            throw new IllegalStateException("OAuthRestConnection should not be created with an HttpRequestOptions that provides an Authentication");
        }
        return httpRequestOptions;
    }

    @Override
    protected void authenticate(HttpRequestBuilder httpRequestBuilder) {
        httpRequestBuilder.addHeader("Authorization", "Bearer " + this.oauthState.getAccessToken());
    }

    @Override
    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        super.sendAsync(request).whenComplete((response, exception) -> {
            try {
                if (exception != null) {
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                try {
                    this.throwAccessTokenExpiredExceptionIfNeedsRefreshToken(response.getStatusCode(), this.resourceOwnerId);
                    future.complete((HttpResponse)response);
                }
                catch (AccessTokenExpiredException e) {
                    future.completeExceptionally(e);
                    return;
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public HttpResponse send(HttpRequest request) throws IOException, TimeoutException {
        HttpResponse httpResponse = super.send(request);
        this.throwAccessTokenExpiredExceptionIfNeedsRefreshToken(httpResponse.getStatusCode(), this.resourceOwnerId);
        return httpResponse;
    }

    @Override
    public ConnectionValidationResult validate(HttpRequest request, Function<HttpResponse, ConnectionValidationResult> whenComplete, Function<Exception, ConnectionValidationResult> onError) {
        return super.validate(request, httpResponse -> {
            this.throwAccessTokenExpiredExceptionIfNeedsRefreshToken(httpResponse.getStatusCode(), this.resourceOwnerId);
            return (ConnectionValidationResult)whenComplete.apply((HttpResponse)httpResponse);
        }, onError);
    }

    protected void throwAccessTokenExpiredExceptionIfNeedsRefreshToken(int statusCode, String resourceOwnerId) {
        if (HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode() == statusCode) {
            throw new AccessTokenExpiredException(resourceOwnerId);
        }
    }
}

