/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata;

import com.mulesoft.connectivity.rest.commons.internal.metadata.ConnectivityTypeLoader;
import com.mulesoft.connectivity.rest.commons.internal.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public class ConnectivityXmlTypeLoader
implements ConnectivityTypeLoader {
    private final String schemaPath;
    private final String qName;
    private final XmlTypeLoader typeLoader;

    public ConnectivityXmlTypeLoader(ClassLoader classLoader, String schemaPath, String qName) {
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"classLoader cannot be null");
        Preconditions.checkArgument((!StringUtils.isBlank((String)schemaPath) ? 1 : 0) != 0, (String)"schemaPath cannot be blank");
        Preconditions.checkArgument((!StringUtils.isBlank((String)qName) ? 1 : 0) != 0, (String)"qName cannot be blank");
        this.schemaPath = schemaPath;
        this.qName = qName;
        String schemaContent = FileUtils.readFile(classLoader, schemaPath);
        URL schemaURL = classLoader.getResource(schemaPath);
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaURL.toString(), (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        this.typeLoader = new XmlTypeLoader(schemaCollector);
    }

    @Override
    public MetadataType load() {
        return (MetadataType)this.typeLoader.load(this.qName).orElseThrow(() -> new RuntimeException("Could not load XML Schema: " + this.schemaPath + " QName:" + this.qName));
    }
}

