/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.metadata.input;

import org.mule.metadata.api.model.MetadataType;

import com.mulesoft.connectivity.rest.commons.internal.metadata.ConnectivityJsonTypeLoader;

public abstract class JsonInputMetadataResolver extends SchemaInputMetadataResolver {

  @Override
  public MetadataType getStaticMetadata() {
    ConnectivityJsonTypeLoader jsonTypeLoader = new ConnectivityJsonTypeLoader(getClass().getClassLoader(), getSchemaPath());
    return jsonTypeLoader.load();
  }

}
