/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.valueprovider;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.values.ValueProvider;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;

import javax.inject.Inject;

/**
 * Base class for ValueProvider that injects the Connection, Configuration and ExpressionLanguage that can be used to resolve the
 * values.
 *
 * @since 1.0
 */
public abstract class BaseRestValueProvider implements ValueProvider {

  @Config
  protected RestConfiguration config;

  @Connection
  protected RestConnection connection;

  @Inject
  protected ExpressionLanguage expressionLanguage;

  @Override
  public String getId() {
    return getClass().getSimpleName();
  }

}
