/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import org.mule.runtime.core.api.util.IOUtils;

import java.io.InputStream;

public class FileUtils {

  private FileUtils() {}

  public static String readFile(ClassLoader classLoader, String path) {
    try (InputStream in = classLoader.getResourceAsStream(path)) {
      if (in == null) {
        throw new IllegalArgumentException("Could not find file at " + path);
      }
      return IOUtils.toString(in);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

}
