/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.RestUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.SplitPayloadUtils;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class RestPagingDataWeaveProvider<C extends RestConnection>
extends RestPagingProvider<C> {
    private final ExpressionLanguage expressionLanguage;
    private final String pageItemsExtractorExpression;

    public RestPagingDataWeaveProvider(Function<C, HttpRequestBuilder> requestFactory, MediaType defaultMediaType, PagingStrategy pagingStrategy, ExpressionLanguage expressionLanguage, String pageItemsExtractorExpression) {
        super(requestFactory, defaultMediaType, pagingStrategy);
        Preconditions.checkArgument((expressionLanguage != null ? 1 : 0) != 0, (String)"ExpressionLanguage cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pageItemsExtractorExpression), (String)"pageItemsExtractorExpression cannot be blank");
        this.expressionLanguage = expressionLanguage;
        this.pageItemsExtractorExpression = pageItemsExtractorExpression;
    }

    @Override
    protected List<TypedValue<String>> extractPageItems(TypedValue<String> content, MediaType defaultMediaType) {
        TypedValue payload;
        try {
            payload = this.expressionLanguage.evaluate(this.pageItemsExtractorExpression, content.getDataType(), BindingContext.builder().addBinding("payload", content).build());
        }
        catch (ExpressionRuntimeException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract payload from expression: %s", this.pageItemsExtractorExpression)), (Throwable)e);
        }
        Iterator<TypedValue<?>> iterator = SplitPayloadUtils.split(this.expressionLanguage, payload);
        return RestUtils.toList(iterator, content.getDataType().getMediaType(), defaultMediaType);
    }
}

