/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.MediaTypeUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestUtils;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class RestPagingProvider<C extends RestConnection>
implements PagingProvider<C, TypedValue<String>> {
    protected final MediaType defaultMediaType;
    private final Function<C, HttpRequestBuilder> requestFactory;
    private boolean stopPaging = false;
    private final PagingStrategy pagingStrategy;

    public RestPagingProvider(Function<C, HttpRequestBuilder> requestFactory, MediaType defaultMediaType, PagingStrategy pagingStrategy) {
        this.requestFactory = requestFactory;
        this.defaultMediaType = defaultMediaType;
        this.pagingStrategy = pagingStrategy;
    }

    public final List<TypedValue<String>> getPage(C connection) {
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        HttpRequestBuilder requestBuilder = this.requestFactory.apply(connection);
        requestBuilder = this.pagingStrategy.configureRequest(connection.getBaseUri(), requestBuilder, () -> this.stopPaging());
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        HttpResponse response = this.send(connection, requestBuilder);
        MediaType mediaType = MediaTypeUtils.getMediaType(response, this.defaultMediaType);
        Charset charset = MediaTypeUtils.resolveCharset(mediaType, this.defaultMediaType);
        TypedValue<String> rawPage = RestUtils.consumeStringAndClose(response.getEntity().getContent(), mediaType, charset);
        if (StringUtils.isBlank((String)((String)rawPage.getValue())) || this.stopPaging) {
            return Collections.emptyList();
        }
        List<TypedValue<String>> page = this.extractPageItems(this.postProcess(rawPage, this.defaultMediaType), this.defaultMediaType);
        this.pagingStrategy.onPage(page, rawPage, (MultiMap<String, String>)response.getHeaders(), () -> this.stopPaging());
        return page;
    }

    protected HttpResponse send(C connection, HttpRequestBuilder requestBuilder) {
        try {
            return connection.send(requestBuilder.build());
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    protected abstract List<TypedValue<String>> extractPageItems(TypedValue<String> var1, MediaType var2);

    protected TypedValue<String> postProcess(TypedValue<String> rawPage, MediaType defaultMediaType) {
        return rawPage;
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
    }

    private void stopPaging() {
        this.stopPaging = true;
    }

    public static interface PagingContext {
        public void stopPaging();
    }
}

