/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.LinkHeaderUtils;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public abstract class HypermediaPagingStrategy
implements PagingStrategy {
    private boolean firstPage = true;
    private String nextUrl;

    @Override
    public HttpRequestBuilder configureRequest(String baseUri, HttpRequestBuilder requestBuilder, RestPagingProvider.PagingContext context) {
        if (!this.firstPage) {
            if (StringUtils.isBlank((String)this.nextUrl)) {
                context.stopPaging();
                return requestBuilder;
            }
            HttpRequest baseRequest = requestBuilder.build();
            HttpRequestBuilder builder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().protocol(baseRequest.getProtocol()).method(baseRequest.getMethod()).entity(baseRequest.getEntity())).headers(baseRequest.getHeaders());
            if (this.isFullUrl()) {
                builder.uri(this.nextUrl);
            } else {
                builder.uri(this.buildRequestUriWithPath(baseUri, this.nextUrl)).queryParams(baseRequest.getQueryParams());
            }
            return builder;
        }
        return requestBuilder;
    }

    private boolean isFullUrl() {
        return this.nextUrl.toLowerCase().startsWith("http");
    }

    private String buildRequestUriWithPath(String baseUri, String path) {
        String localPath = path;
        String localBaseUri = baseUri;
        boolean pathStartsWithSlash = localPath.startsWith("/");
        boolean baseEndsInSlash = localBaseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            localPath = localPath.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            localBaseUri = localBaseUri + '/';
        }
        return localBaseUri + localPath;
    }

    @Override
    public void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, MultiMap<String, String> headers, RestPagingProvider.PagingContext context) {
        this.firstPage = false;
        if (StringUtils.isBlank((String)((String)rawPage.getValue()))) {
            this.nextUrl = null;
            context.stopPaging();
        } else {
            this.nextUrl = this.extractNextUrl(rawPage, headers);
        }
    }

    protected abstract String extractNextUrl(TypedValue<String> var1, MultiMap<String, String> var2);

    protected Map<String, String> buildLinkHeaderMap(String linkHeader) {
        return LinkHeaderUtils.buildLinkHeaderMap(linkHeader);
    }
}

