/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import java.util.List;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public abstract class MarkerPagingStrategy
implements PagingStrategy {
    private final String markerParamName;
    private boolean firstPage = true;
    private String nextMarker;

    public MarkerPagingStrategy(String markerParamName) {
        this.markerParamName = markerParamName;
    }

    @Override
    public HttpRequestBuilder configureRequest(String baseUri, HttpRequestBuilder requestBuilder, RestPagingProvider.PagingContext context) {
        if (!this.firstPage) {
            if (StringUtils.isBlank((String)this.nextMarker)) {
                context.stopPaging();
                return requestBuilder;
            }
            requestBuilder.addQueryParam(this.markerParamName, this.nextMarker);
        }
        return requestBuilder;
    }

    @Override
    public void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, MultiMap<String, String> headers, RestPagingProvider.PagingContext context) {
        this.firstPage = false;
        if (StringUtils.isBlank((String)((String)rawPage.getValue()))) {
            this.nextMarker = null;
            context.stopPaging();
        } else {
            this.nextMarker = this.getNextMarker(rawPage, headers);
        }
    }

    protected abstract String getNextMarker(TypedValue<String> var1, MultiMap<String, String> var2);
}

