/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.util.Iterator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class SplitPayloadUtils {
    public static Iterator<TypedValue<?>> split(ExpressionLanguage expressionLanguage, TypedValue<?> payload) {
        Iterator splitResult;
        if (SplitPayloadUtils.isXml(payload)) {
            SplitPayloadUtils.validatePayload(expressionLanguage, payload, "payload is Object");
            splitResult = expressionLanguage.split("payload[0] default []", SplitPayloadUtils.buildContext(payload));
        } else {
            SplitPayloadUtils.validatePayload(expressionLanguage, payload, "payload is Array");
            splitResult = expressionLanguage.split("payload", SplitPayloadUtils.buildContext(payload));
        }
        return splitResult;
    }

    private static boolean isXml(TypedValue<?> payload) {
        return payload.getDataType().getMediaType().matches(MediaType.APPLICATION_XML) || payload.getDataType().getMediaType().matches(MediaType.XML);
    }

    private static void validatePayload(ExpressionLanguage expressionLanguage, TypedValue<?> payload, String expression) {
        TypedValue result = expressionLanguage.evaluate(expression, DataType.BOOLEAN, SplitPayloadUtils.buildContext(payload));
        if (result.getValue().equals(false)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to split payload that is not an array. Result Payload: '%s'.", payload.getValue())));
        }
    }

    private static BindingContext buildContext(TypedValue<?> payload) {
        return BindingContext.builder().addBinding("payload", payload).build();
    }
}

