/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.oauth;

import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnectionProvider;

/**
 * Base class for {@link OAuthRestConnection}s that authenticate using OAuth with the Authorization Code Grant Type.
 * 
 * @param <C>
 */
public abstract class BaseAuthorizationCodeConnectionProvider<C extends OAuthRestConnection> extends RestConnectionProvider<C> {

  protected AuthorizationCodeState oauthState;

  protected AuthorizationCodeState getOAuthState() {
    return oauthState;
  }

  /**
   * Override this method if a custom condition needs to be implemented to check if refresh token is needed with a custom
   * implementation of {@link OAuthRestConnection}.
   *
   * @param httpClient the client to perform the requests.
   * @param httpRequestOptions the options for the http request client to perfom the requests.
   * @return a new {@link C} connection.
   */
  @Override
  protected C createConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions) {
    return (C) new OAuthRestConnection(httpClient, httpRequestOptions, getBaseUri(), getOAuthState(),
                                       getOAuthState().getResourceOwnerId());
  }
}
