/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata;

import static com.mulesoft.connectivity.rest.commons.internal.util.FileUtils.readFile;
import static org.mule.runtime.api.util.Preconditions.checkArgument;
import static org.mule.runtime.core.api.util.StringUtils.isBlank;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;

public class ConnectivityJsonTypeLoader implements ConnectivityTypeLoader {

  private final String schemaPath;
  private final TypeLoader typeLoader;

  public ConnectivityJsonTypeLoader(ClassLoader classLoader, String schemaPath) {
    checkArgument(classLoader != null, "classLoader cannot be null");
    checkArgument(!isBlank(schemaPath), "schemaPath cannot be blank");

    this.schemaPath = schemaPath;
    String schemaContent = readFile(classLoader, schemaPath);
    typeLoader = new RestJsonTypeLoader(schemaContent);
  }

  public MetadataType load() {
    return typeLoader.load(null)
        .orElseThrow(() -> new RuntimeException("Could not load Json Schema: " + schemaPath));
  }

}
