/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static java.lang.String.format;
import static java.nio.charset.Charset.defaultCharset;
import static org.mule.runtime.api.metadata.MediaType.parse;
import static org.mule.runtime.http.api.HttpHeaders.Names.CONTENT_TYPE;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.nio.charset.Charset;

import org.slf4j.Logger;

public class MediaTypeUtils {

  protected static final Logger LOGGER = getLogger(MediaTypeUtils.class);

  public static MediaType getMediaType(HttpResponse response, MediaType defaultResponseMediaType) {
    MediaType contentType = defaultResponseMediaType;
    String responseContentType = response.getHeaders().get(CONTENT_TYPE);
    if (responseContentType != null) {
      try {
        contentType = parse(responseContentType);
      } catch (Exception e) {
        if (LOGGER.isDebugEnabled()) {
          LOGGER.debug(format("Response Content-Type '%s' could not be parsed to a valid Media Type. Will ignore",
                              responseContentType),
                       e);
        }
      }
    }
    return contentType;
  }

  public static Charset resolveCharset(MediaType mediaType, MediaType defaultMediaType) {
    return mediaType.getCharset().orElse(defaultMediaType.getCharset().orElse(defaultCharset()));
  }

}
