/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.RestUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class PageNumberPagingStrategy
implements PagingStrategy {
    private final String pageNumberParamName;
    private int pageNumber;

    public PageNumberPagingStrategy(String pageNumberParamName, int initialPageNumber) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pageNumberParamName), (String)"pageNumberParamName cannot be blank");
        this.pageNumberParamName = pageNumberParamName;
        this.pageNumber = initialPageNumber;
    }

    @Override
    public HttpRequestBuilder configureRequest(String baseUri, HttpRequestBuilder requestBuilder, RestPagingProvider.PagingContext context) {
        requestBuilder.addQueryParam(this.pageNumberParamName, RestUtils.stringValue(this.pageNumber));
        return requestBuilder;
    }

    @Override
    public void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, MultiMap<String, String> headers, RestPagingProvider.PagingContext context) {
        Integer totalPages = this.extractPageCount(rawPage, headers);
        if (totalPages != null && this.pageNumber == totalPages) {
            context.stopPaging();
        } else {
            ++this.pageNumber;
        }
    }

    public Integer extractPageCount(TypedValue<String> rawPage, MultiMap<String, String> headers) {
        return null;
    }
}

