/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableCursorProviderInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCloseableCursorProviderInputStream.class);
    private final CursorStreamProvider cursorProvider;
    private final InputStream stream;

    public AutoCloseableCursorProviderInputStream(CursorStreamProvider cursorProvider) {
        this.cursorProvider = cursorProvider;
        this.stream = (InputStream)cursorProvider.openCursor();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            try {
                this.cursorProvider.close();
            }
            catch (Exception e) {
                LOGGER.error("Error closing cursor provider", (Throwable)e);
            }
            try {
                this.cursorProvider.releaseResources();
            }
            catch (Exception e) {
                LOGGER.error("Error releasing cursor provider resources", (Throwable)e);
            }
        }
    }
}

