/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider.PagingContext;

import java.util.List;

/**
 * Strategy to allow implementing different types of pagination.
 *
 * @since 1.0
 */
public interface PagingStrategy {

  /**
   * Depending on the paging strategy, different parameters or headers may need to be passed. This method receives the raw output
   * of the requestBuilder in order to configure the custom parameters that apply.
   *
   * @param baseUri the base uri of the REST API being consumed.
   * @param requestBuilder a {@link HttpRequestBuilder}.
   * @param context the pagination context to allow stopping the pagination mechanism.
   * @return the same {@link HttpRequestBuilder} configured or a new one.
   */
  HttpRequestBuilder configureRequest(String baseUri, HttpRequestBuilder requestBuilder, PagingContext context);

  /**
   * Invoked each time a page is obtained. Depending on the paging strategy, will change its attributes (like page number or next
   * marker) to prepare for the next http call.
   *
   * @param page the obtained page
   * @param context the pagination context to allow stopping the pagination mechanism.
   */
  void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, MultiMap<String, String> headers, PagingContext context);

}
