/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.internal.util.MediaTypeUtils;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class BaseRestOperation {
    @Inject
    ExpressionLanguage expressionLanguage;

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    protected void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        Preconditions.checkArgument((expressionLanguage != null ? 1 : 0) != 0, (String)"ExpressionLanguage cannot be null");
        this.expressionLanguage = expressionLanguage;
    }

    protected final Function<HttpResponse, HttpResponse> throwModuleExceptionIfErrorResponse() {
        return httpResponse -> {
            Optional<ErrorTypeDefinition<Enum<?>>> errorTypeDefinitionOptional = this.httpResponseToErrorTypeDefinition().apply((HttpResponse)httpResponse);
            if (errorTypeDefinitionOptional.isPresent()) {
                ErrorTypeDefinition<? extends Enum<?>> errorTypeDefinition = errorTypeDefinitionOptional.get();
                throw this.createModuleException((HttpResponse)httpResponse, (ErrorTypeDefinition)errorTypeDefinition);
            }
            return httpResponse;
        };
    }

    protected Function<HttpResponse, Optional<ErrorTypeDefinition<? extends Enum<?>>>> httpResponseToErrorTypeDefinition() {
        return httpResponse -> RestError.getErrorTypeDefinitionByStatusCode(httpResponse.getStatusCode());
    }

    protected <E extends Enum<E>> ModuleException createModuleException(HttpResponse httpResponse, ErrorTypeDefinition<E> errorTypeDefinition) {
        return new ModuleException(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase(), errorTypeDefinition);
    }

    protected final <P, A, T> Function<Throwable, T> notifyCompletionCallbackError(CompletionCallback<P, A> completionCallback) {
        return throwable -> {
            Throwable rootCause = throwable;
            if (throwable instanceof CompletionException) {
                rootCause = throwable.getCause();
            }
            completionCallback.error((Throwable)this.toConnectivityErrorFunction().apply(rootCause));
            return null;
        };
    }

    protected Function<Throwable, ModuleException> toConnectivityErrorFunction() {
        return throwable -> {
            if (throwable instanceof ModuleException) {
                return (ModuleException)throwable;
            }
            if (throwable instanceof TimeoutException) {
                return new ModuleException((ErrorTypeDefinition)RestError.TIMEOUT, throwable);
            }
            return new ModuleException((ErrorTypeDefinition)RestError.CONNECTIVITY, throwable);
        };
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    protected final MediaType resolveDefaultResponseMediaType(RestConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    protected final MediaType getMediaType(HttpResponse response, MediaType defaultResponseMediaType) {
        return MediaTypeUtils.getMediaType(response, defaultResponseMediaType);
    }
}

