/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.MarkerPagingStrategy;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;

public class DataweaveMarkerPagingStrategy
extends MarkerPagingStrategy {
    private final String nextMarkerExpression;
    private final ExpressionLanguage expressionLanguage;

    public DataweaveMarkerPagingStrategy(String markerParamName, String nextMarkerExpression, ExpressionLanguage expressionLanguage) {
        super(markerParamName);
        Preconditions.checkArgument((expressionLanguage != null ? 1 : 0) != 0, (String)"ExpressionLanguage cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)nextMarkerExpression), (String)"nextMarkerExpression cannot be blank");
        this.nextMarkerExpression = nextMarkerExpression;
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    protected String getNextMarker(TypedValue<String> rawPage, MultiMap<String, String> headers) {
        try {
            return (String)this.expressionLanguage.evaluate(this.nextMarkerExpression, DataType.STRING, BindingContext.builder().addBinding("payload", rawPage).addBinding("headers", TypedValue.of(headers)).build()).getValue();
        }
        catch (ExpressionRuntimeException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract next marker from expression: %s", this.nextMarkerExpression)), (Throwable)e);
        }
    }
}

