/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.config;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;

import java.nio.charset.Charset;

/**
 * Base class for configuration objects. It is required to be extended in order to annotate with sdk elements (operations,
 * connection providers, etc)
 *
 * @since 1.0
 */
public abstract class RestConfiguration implements Initialisable {

  @DefaultEncoding
  protected String defaultEncoding;
  protected Charset charset;

  @Override
  public void initialise() {
    charset = Charset.forName(defaultEncoding);
  }

  /**
   * @return the default charset defined in Mule Runtime.
   */
  public Charset getCharset() {
    return charset;
  }

}
