/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import static com.mulesoft.connectivity.rest.commons.api.error.RestError.CONNECTIVITY;
import static com.mulesoft.connectivity.rest.commons.api.error.RestError.TIMEOUT;
import static com.mulesoft.connectivity.rest.commons.api.error.RestError.getErrorTypeDefinitionByStatusCode;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;

import java.util.Optional;
import java.util.concurrent.TimeoutException;

/**
 * Implementation that handles RESTfull responses and handling errors based on {@link RestError}.
 */
public class DefaultRestConnection extends BaseRestConnection<ModuleException, ErrorTypeDefinition<RestError>> {

  public DefaultRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri,
                               ExpressionLanguage expressionLanguage) {
    super(httpClient, httpRequestOptions, baseUri, expressionLanguage);
  }

  @Override
  protected HttpEntity materializeHttpResponseEntity(HttpEntity httpEntity) {
    return httpEntity;
  }

  @Override
  protected Optional<ErrorTypeDefinition<RestError>> httpResponseToErrorTypeDefinition(HttpResponse httpResponse,
                                                                                       MediaType mediaType) {
    return getErrorTypeDefinitionByStatusCode(httpResponse.getStatusCode());
  }

  @Override
  protected ModuleException createModuleException(HttpResponse httpResponse,
                                                  ErrorTypeDefinition<RestError> errorTypeDefinition,
                                                  MediaType defaultMediaType) {
    return new ModuleException(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase(),
                               errorTypeDefinition);
  }

  @Override
  protected ModuleException toConnectivityErrorFunction(Throwable throwable) {
    if (throwable instanceof ModuleException) {
      return (ModuleException) throwable;
    }
    if (throwable instanceof TimeoutException) {
      return new ModuleException(TIMEOUT, throwable);
    }
    return new ModuleException(CONNECTIVITY, throwable);
  }

}
