/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.basic;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnectionProvider;

/**
 * Base class for {@link RestConnection}s that authenticate using Basic mechanism.
 *
 * @since 1.0
 */
public abstract class BaseBasicAuthenticationConnectionProvider<C extends DefaultRestConnection>
    extends RestConnectionProvider<C> {

  protected abstract String getUsername();

  protected abstract String getPassword();

  @Override
  protected final HttpAuthentication buildAuthentication() {
    return HttpAuthentication.basic(getUsername(), getPassword()).build();
  }

  @Override
  protected C createConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions,
                               ExpressionLanguage expressionLanguage) {
    return (C) new DefaultRestConnection(httpClient, httpRequestOptions, getBaseUri(), expressionLanguage);
  }

}
