/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.bearer;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnectionProvider;

/**
 * Base class for {@link RestConnection}s that authenticate using Bearer mechanism.
 * 
 * @param <C>
 */
public abstract class BaseBearerAuthenticationConnectionProvider<C extends BearerRestConnection>
    extends RestConnectionProvider<C> {

  @Override
  protected C createConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions,
                               ExpressionLanguage expressionLanguage) {
    return (C) new BearerRestConnection(httpClient, httpRequestOptions, getBaseUri(), expressionLanguage, getToken());
  }

  /**
   * Returns the token used to authenticate the requests that will be used to build the corresponding authentication.
   *
   * @return The token used to authenticate the requests.
   */
  protected abstract String getToken();

}
