/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.bearer;

import static java.util.Objects.requireNonNull;
import static org.mule.runtime.http.api.HttpHeaders.Names.AUTHORIZATION;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;

/**
 * Specialization of {@link DefaultRestConnection} for resources protected with Bearer, regardless of the grant type.
 */
public class BearerRestConnection extends DefaultRestConnection {

  private final String token;

  public BearerRestConnection(HttpClient httpClient,
                              HttpRequestOptions httpRequestOptions, String baseUri,
                              ExpressionLanguage expressionLanguage,
                              String token) {
    super(httpClient, httpRequestOptions, baseUri, expressionLanguage);
    requireNonNull(token, "token cannot be null");

    this.token = token;
  }

  @Override
  protected void authenticate(HttpRequestBuilder httpRequestBuilder) {
    httpRequestBuilder.addHeader(AUTHORIZATION, "Bearer " + token);
  }

}
