/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.dw;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

/**
 * Wrapping class of the result of an expression evaluation using {@link CommonsExpressionLanguage}. It can resolve the value as
 * String, byte[] or InputStream.
 *
 * @since 1.0
 */
public class CommonsExpressionLanguageValue {

  private final String value;

  public CommonsExpressionLanguageValue(String value) {
    this.value = value;
  }

  public byte[] asByteArray(Charset charset) {
    return value.getBytes(charset);
  }

  public String asString() {
    return value;
  }

  public InputStream asInputStream(Charset charset) {
    return new ByteArrayInputStream(value.getBytes(charset));
  }

  @Override
  public String toString() {
    return "CommonsExpressionLanguageValue{" +
        "value='" + value + '\'' +
        '}';
  }

}
