/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.dw;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;

import com.mulesoft.connectivity.rest.commons.api.dw.CommonsBindingContext;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguage;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguageValue;
import com.mulesoft.connectivity.rest.commons.internal.util.AutoCloseableCursorProviderInputStream;

import java.io.IOException;

public class CommonsExpressionLanguageImpl implements CommonsExpressionLanguage {

  private ExpressionLanguage expressionLanguage;

  public CommonsExpressionLanguageImpl(ExpressionLanguage expressionLanguage) {
    this.expressionLanguage = expressionLanguage;
  }

  @Override
  public CommonsExpressionLanguageValue evaluateJson(String expression, CommonsBindingContext commonsBindingContext) {
    return evaluate(expression, commonsBindingContext, DataType.JSON_STRING);
  }

  @Override
  public CommonsExpressionLanguageValue evaluateXml(String expression, CommonsBindingContext commonsBindingContext) {
    return evaluate(expression, commonsBindingContext, DataType.XML_STRING);
  }

  @Override
  public String evaluateAsJavaString(String expression, CommonsBindingContext commonsBindingContext) {
    return evaluateJava(expression, commonsBindingContext, DataType.STRING);
  }

  @Override
  public Boolean evaluateAsJavaBoolean(String expression, CommonsBindingContext commonsBindingContext) {
    return evaluateJava(expression, commonsBindingContext, DataType.BOOLEAN);
  }

  @Override
  public Number evaluateAsJavaNumber(String expression, CommonsBindingContext commonsBindingContext) {
    return evaluateJava(expression, commonsBindingContext, DataType.NUMBER);
  }

  @Override
  public CommonsExpressionLanguageValue evaluate(String expression, CommonsBindingContext commonsBindingContext,
                                                 DataType dataType) {
    TypedValue<?> typedValue = expressionLanguage.evaluate(expression, dataType, commonsBindingContext.bindingContext());
    CursorStreamProvider cursorStreamProvider = (CursorStreamProvider) typedValue.getValue();
    try (AutoCloseableCursorProviderInputStream autoCloseableCursorProviderInputStream =
        new AutoCloseableCursorProviderInputStream(cursorStreamProvider)) {
      String result = IOUtils.toString(autoCloseableCursorProviderInputStream,
                                       typedValue.getDataType().getMediaType().getCharset()
                                           .orElseThrow(() -> new MuleRuntimeException(createStaticMessage("Error parsing ExpressionLanguage Response"))));
      return new CommonsExpressionLanguageValue(result);
    } catch (IOException e) {
      throw new MuleRuntimeException(createStaticMessage("There was an error either reading the evaluated input stream or closing it"),
                                     e);
    }
  }

  private <C> C evaluateJava(String expression, CommonsBindingContext commonsBindingContext, DataType dataType) {
    TypedValue<C> evaluate =
        (TypedValue<C>) expressionLanguage.evaluate(expression, dataType, commonsBindingContext.bindingContext());
    return evaluate.getValue();
  }
}
