/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.exception.MuleRuntimeException;

import com.mulesoft.connectivity.rest.commons.api.metadata.ExpressionLanguageMetadataService;

/**
 * Implementation that delegates to Mule's {@link org.mule.runtime.api.metadata.ExpressionLanguageMetadataService}.
 *
 * @since 1.0
 */
public class WeaveExpressionLanguageMetadataService implements ExpressionLanguageMetadataService {

  private org.mule.runtime.api.metadata.ExpressionLanguageMetadataService muleExpressionLanguageMetadataService;

  public WeaveExpressionLanguageMetadataService(
                                                org.mule.runtime.api.metadata.ExpressionLanguageMetadataService muleExpressionLanguageMetadataService) {
    this.muleExpressionLanguageMetadataService = muleExpressionLanguageMetadataService;
  }

  @Override
  public MetadataType getOutputType(MetadataType type, String expression) {
    return getOutputType(TypeBindings.builder()
        .addBinding("payload", type)
        .build(), expression);
  }

  @Override
  public MetadataType getOutputType(TypeBindings typeBindings, String expression) {
    CollectorMessageCallback collectorMessageCallback = new CollectorMessageCallback();
    MetadataType outputType =
        muleExpressionLanguageMetadataService.getOutputType(typeBindings, expression, collectorMessageCallback);
    collectorMessageCallback.throwIfErrorCollected();
    return outputType;
  }

  private class CollectorMessageCallback
      implements org.mule.runtime.api.metadata.ExpressionLanguageMetadataService.MessageCallback {

    private String message;
    private org.mule.runtime.api.metadata.ExpressionLanguageMetadataService.MessageLocation messageLocation;

    @Override
    public void warning(String message,
                        org.mule.runtime.api.metadata.ExpressionLanguageMetadataService.MessageLocation messageLocation) {

    }

    @Override
    public void error(String message,
                      org.mule.runtime.api.metadata.ExpressionLanguageMetadataService.MessageLocation messageLocation) {
      this.message = message;
      this.messageLocation = messageLocation;
    }

    public void throwIfErrorCollected() {
      if (message != null) {
        throw new MuleRuntimeException(createStaticMessage("There was an error while resolving the metadata type. Cause: "
            + message + " Trace: at (line: "
            + messageLocation.getStartPosition().getLine()
            + ", column: " + messageLocation.getStartPosition().getColumn()
            + ")"));
      }
    }
  }

}
