/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import static java.lang.Integer.MAX_VALUE;
import static java.lang.String.valueOf;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.text.NumberFormat;
import java.util.Set;

import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;

public class EnumHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof EnumSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final EnumSchema enumSchema = (EnumSchema) schema;
    final StringTypeBuilder enumMetadataBuilder = root.stringType();
    final Set<Object> possibleValues = enumSchema.getPossibleValues();
    final String[] stringValues = possibleValues.stream().map(this::stringValue).toArray(String[]::new);
    enumMetadataBuilder.enumOf(stringValues);
    if (schema.getId() != null) {
      enumMetadataBuilder.id(schema.getId());
    }
    return enumMetadataBuilder;
  }

  /***
   * Transforms a value into a tailored String representation for HTTP requests.
   *
   * @return String representation of the parameter
   */
  private String stringValue(Object o) {
    if (o == null) {
      return null;
    }

    if (o instanceof String) {
      return (String) o;
    }

    if (o instanceof Integer | o instanceof Long | o instanceof Double) {
      NumberFormat numberFormat = NumberFormat.getInstance();
      numberFormat.setMaximumFractionDigits(MAX_VALUE);
      numberFormat.setGroupingUsed(false);
      return numberFormat.format(o);
    }

    return valueOf(o);
  }
}
