/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON;

import org.mule.runtime.api.metadata.MediaType;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;

import java.nio.charset.Charset;

public class MediaTypeUtils {

  public static final MediaType APPLICATION_YAML = MediaType.create("application", "yaml");

  public static final MediaType YAML = MediaType.create("text", "yaml");

  /**
   * Resolves the default {@link MediaType} to be used when processing the response.
   *
   * @param defaultCharset from Mule Runtime to be used on those media types that doesn't provide a default charset.
   * @param defaultResponseMediaType the default response {@link MediaType} in case if server response doesn't send this
   *        information in the header {@code Content-Type}, which may or may not have a charset parameter.
   * @return the {@link MediaType} with the charset resolved, by a default value by mime type or by the provided as parameter.
   */
  public static MediaType resolveDefaultResponseMediaType(Charset defaultCharset, MediaType defaultResponseMediaType) {
    MediaType mediaType = defaultResponseMediaType;
    if (!mediaType.getCharset().isPresent()) {
      if (mediaType.matches(APPLICATION_JSON) || mediaType.matches(MediaType.JSON) ||
          mediaType.matches(APPLICATION_YAML) || mediaType.matches(YAML)) {
        mediaType = mediaType.withCharset(UTF_8);
      } else {
        mediaType = mediaType.withCharset(defaultCharset);
      }
    }
    return mediaType;
  }

  /**
   * Resolves the default {@link MediaType} to be used when processing the response.
   *
   * @param config {@link RestConfiguration} to get the defaultCharset from Mule Runtime.
   * @return the {@link MediaType}.
   */
  public static MediaType resolveDefaultResponseMediaType(RestConfiguration config, MediaType defaultMediaType) {
    MediaType mediaType = defaultMediaType;
    if (!mediaType.getCharset().isPresent()) {
      mediaType = mediaType.withCharset(config.getCharset());
    }

    return mediaType;
  }

}
