/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguage;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseResult;
import com.mulesoft.connectivity.rest.commons.internal.dw.CommonsExpressionLanguageImpl;
import com.mulesoft.connectivity.rest.commons.internal.http.HttpResponseAttributes;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestConnection<E extends ModuleException, T extends ErrorTypeDefinition<? extends Enum<?>>>
implements RestConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRestConnection.class);
    private final HttpClient httpClient;
    private final HttpRequestOptions httpRequestOptions;
    private final String baseUri;
    private ExpressionLanguage expressionLanguage;

    public BaseRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri, ExpressionLanguage expressionLanguage) {
        Objects.requireNonNull(httpClient, "httpClient cannot be null");
        Objects.requireNonNull(httpRequestOptions, "httpRequestOptions cannot be null");
        Objects.requireNonNull(expressionLanguage, "expressionLanguage cannot be null");
        this.httpClient = httpClient;
        this.httpRequestOptions = httpRequestOptions;
        this.baseUri = baseUri;
        this.expressionLanguage = expressionLanguage;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpRequestOptions getHttpRequestOptions() {
        return this.httpRequestOptions;
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    protected CommonsExpressionLanguage getCommonsExpressionLanguage() {
        return new CommonsExpressionLanguageImpl(this.expressionLanguage);
    }

    @Override
    public CompletableFuture<HttpResponseResult> sendAsync(HttpRequest request, MediaType defaultResponseMediaType) {
        CompletableFuture<HttpResponseResult> future = new CompletableFuture<HttpResponseResult>();
        try {
            this.getHttpClient().sendAsync(this.beforeRequest(request), this.getHttpRequestOptions()).whenComplete((httpResponse, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)this.toConnectivityErrorFunction(throwable.getCause()));
                    return;
                }
                MediaType mediaType = this.getMediaType((HttpResponse)httpResponse, defaultResponseMediaType);
                try {
                    HttpResponse response = this.throwModuleExceptionIfErrorResponse((HttpResponse)httpResponse, mediaType);
                    future.complete(this.toResult(response, mediaType));
                }
                catch (Exception e) {
                    future.completeExceptionally((Throwable)this.toConnectivityErrorFunction(e));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally((Throwable)this.toConnectivityErrorFunction(t));
        }
        return future;
    }

    protected final MediaType getMediaType(HttpResponse response, MediaType defaultResponseMediaType) {
        Preconditions.checkArgument((boolean)defaultResponseMediaType.getCharset().isPresent(), (String)"'defaultResponseMediaType' should have a charset defined");
        MediaType contentType = defaultResponseMediaType;
        String responseContentType = (String)response.getHeaders().get((Object)"Content-Type");
        if (responseContentType != null) {
            try {
                contentType = MediaType.parse((String)responseContentType);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Server response 'Content-Type': '%s' could not be parsed to a valid Media Type. Will ignore", responseContentType), (Throwable)e);
                }
                return contentType;
            }
            if (!contentType.getCharset().isPresent()) {
                if (!contentType.matches(defaultResponseMediaType)) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Server response 'Content-Type': '%s' is missing charset but 'defaultResponseMediaType': '%s' doesn't match to resolve the charset/encoding", (Object[])new Object[]{contentType, defaultResponseMediaType}));
                }
                contentType = contentType.withCharset((Charset)defaultResponseMediaType.getCharset().get());
            }
        }
        return contentType;
    }

    protected HttpResponseResult toResult(HttpResponse httpResponse, MediaType mediaType) {
        HttpEntity entity = httpResponse.getEntity();
        return HttpResponseResult.builder().entityContent(entity.getContent()).mediaType(mediaType).length(entity.getBytesLength()).httpResponseAttributes(new HttpResponseAttributes(httpResponse.getStatusCode(), httpResponse.getReasonPhrase(), (MultiMap<String, String>)httpResponse.getHeaders())).build();
    }

    @Override
    public HttpResponseResult send(HttpRequest request, MediaType defaultResponseMediaType) throws E {
        try {
            HttpResponse httpResponse = this.getHttpClient().send(this.beforeRequest(request), this.getHttpRequestOptions());
            MediaType mediaType = this.getMediaType(httpResponse, defaultResponseMediaType);
            return this.toResult(this.throwModuleExceptionIfErrorResponse(httpResponse, mediaType), mediaType);
        }
        catch (Exception e) {
            throw this.toConnectivityErrorFunction(e);
        }
    }

    @Override
    public ConnectionValidationResult validate(HttpRequest request, Function<HttpResponse, ConnectionValidationResult> whenComplete, Function<Exception, ConnectionValidationResult> onError) {
        try {
            return whenComplete.apply(this.getHttpClient().send(this.beforeRequest(request), this.getHttpRequestOptions()));
        }
        catch (Exception e) {
            return onError.apply(e);
        }
    }

    protected HttpRequest beforeRequest(HttpRequest request) {
        HttpRequestBuilder httpRequestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(request.getMethod()).protocol(request.getProtocol()).uri(request.getUri()).queryParams(request.getQueryParams()).headers(request.getHeaders())).entity(request.getEntity());
        this.authenticate(httpRequestBuilder);
        return httpRequestBuilder.build();
    }

    protected void authenticate(HttpRequestBuilder httpRequestBuilder) {
    }

    protected final HttpResponse throwModuleExceptionIfErrorResponse(HttpResponse httpResponse, MediaType mediaType) {
        httpResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().headers(httpResponse.getHeaders())).statusCode(Integer.valueOf(httpResponse.getStatusCode())).reasonPhrase(httpResponse.getReasonPhrase()).entity(this.materializeHttpResponseEntity(httpResponse.getEntity()))).build();
        Optional<T> errorTypeDefinitionOptional = this.httpResponseToErrorTypeDefinition(httpResponse, mediaType);
        if (errorTypeDefinitionOptional.isPresent()) {
            ErrorTypeDefinition errorTypeDefinition = (ErrorTypeDefinition)errorTypeDefinitionOptional.get();
            throw this.createModuleException(httpResponse, errorTypeDefinition, mediaType);
        }
        return httpResponse;
    }

    protected abstract HttpEntity materializeHttpResponseEntity(HttpEntity var1);

    protected abstract Optional<T> httpResponseToErrorTypeDefinition(HttpResponse var1, MediaType var2);

    protected abstract E createModuleException(HttpResponse var1, T var2, MediaType var3);

    protected abstract E toConnectivityErrorFunction(Throwable var1);
}

