/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.BaseRestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class DefaultRestConnection
extends BaseRestConnection<ModuleException, ErrorTypeDefinition<RestError>> {
    public DefaultRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri, ExpressionLanguage expressionLanguage) {
        super(httpClient, httpRequestOptions, baseUri, expressionLanguage);
    }

    @Override
    protected HttpEntity materializeHttpResponseEntity(HttpEntity httpEntity) {
        return httpEntity;
    }

    @Override
    protected Optional<ErrorTypeDefinition<RestError>> httpResponseToErrorTypeDefinition(HttpResponse httpResponse, MediaType mediaType) {
        return RestError.getErrorTypeDefinitionByStatusCode(httpResponse.getStatusCode());
    }

    @Override
    protected ModuleException createModuleException(HttpResponse httpResponse, ErrorTypeDefinition<RestError> errorTypeDefinition, MediaType defaultMediaType) {
        return new ModuleException(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase(), errorTypeDefinition);
    }

    @Override
    protected ModuleException toConnectivityErrorFunction(Throwable throwable) {
        if (throwable instanceof ModuleException) {
            return (ModuleException)throwable;
        }
        if (throwable instanceof TimeoutException) {
            return new ModuleException((ErrorTypeDefinition)RestError.TIMEOUT, throwable);
        }
        return new ModuleException((ErrorTypeDefinition)RestError.CONNECTIVITY, throwable);
    }
}

