/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.oauth;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import java.util.Objects;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class OAuthRestConnection<O extends OAuthState>
extends DefaultRestConnection {
    private final O oauthState;
    private final String resourceOwnerId;

    public OAuthRestConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri, ExpressionLanguage expressionLanguage, O oauthState, String resourceOwnerId) {
        super(httpClient, OAuthRestConnection.assertNoAuthenticationProvided(httpRequestOptions), baseUri, expressionLanguage);
        Objects.requireNonNull(oauthState, "oauthState cannot be null");
        this.oauthState = oauthState;
        this.resourceOwnerId = resourceOwnerId;
    }

    private static HttpRequestOptions assertNoAuthenticationProvided(HttpRequestOptions httpRequestOptions) {
        if (httpRequestOptions.getAuthentication().isPresent()) {
            throw new IllegalStateException("OAuthRestConnection should not be created with an HttpRequestOptions that provides an Authentication");
        }
        return httpRequestOptions;
    }

    @Override
    protected final void authenticate(HttpRequestBuilder httpRequestBuilder) {
        this.authenticate(httpRequestBuilder, this.oauthState);
    }

    protected void authenticate(HttpRequestBuilder httpRequestBuilder, O oauthState) {
        httpRequestBuilder.addHeader("Authorization", "Bearer " + oauthState.getAccessToken());
    }

    @Override
    protected ModuleException toConnectivityErrorFunction(Throwable throwable) {
        ModuleException moduleException = super.toConnectivityErrorFunction(throwable);
        try {
            this.throwAccessTokenExpiredExceptionIfNeedsRefreshToken(moduleException.getType(), this.resourceOwnerId);
        }
        catch (AccessTokenExpiredException e) {
            return new ModuleException(moduleException.getType(), (Throwable)e);
        }
        return moduleException;
    }

    protected void throwAccessTokenExpiredExceptionIfNeedsRefreshToken(ErrorTypeDefinition errorTypeDefinition, String resourceOwnerId) {
        if (RestError.UNAUTHORIZED.name() == errorTypeDefinition.getType()) {
            if (resourceOwnerId == null) {
                throw new AccessTokenExpiredException();
            }
            throw new AccessTokenExpiredException(resourceOwnerId);
        }
    }
}

