/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.error;

import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;

public enum RestError implements ErrorTypeDefinition<RestError>
{
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    CLIENT_ERROR(CONNECTIVITY),
    TIMEOUT(CLIENT_ERROR),
    UNAUTHORIZED(CLIENT_ERROR),
    NOT_FOUND(CLIENT_ERROR),
    TOO_MANY_REQUESTS(CLIENT_ERROR),
    BAD_REQUEST(CLIENT_ERROR),
    UNSUPPORTED_MEDIA_TYPE(CLIENT_ERROR),
    NOT_ACCEPTABLE(CONNECTIVITY),
    SERVER_ERROR(CONNECTIVITY),
    INTERNAL_SERVER_ERROR(SERVER_ERROR),
    SERVICE_UNAVAILABLE(SERVER_ERROR);

    private ErrorTypeDefinition<?> parentErrorType;
    private final String message = this.name().replace("_", " ").toLowerCase();

    private RestError() {
    }

    private RestError(ErrorTypeDefinition<?> parentErrorType) {
        this();
        this.parentErrorType = parentErrorType;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    public static Optional<ErrorTypeDefinition<RestError>> getErrorTypeDefinitionByStatusCode(int statusCode) {
        RestError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            try {
                error = RestError.valueOf(status.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (error == null) {
            if (statusCode >= 400 && statusCode < 500) {
                error = CLIENT_ERROR;
            } else if (statusCode >= 500) {
                error = SERVER_ERROR;
            }
        }
        return Optional.ofNullable(error);
    }

    public String getErrorMessage() {
        return this.message;
    }
}

