/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguage;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.internal.dw.CommonsExpressionLanguageImpl;
import com.mulesoft.connectivity.rest.commons.internal.util.MediaTypeUtils;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public abstract class BaseRestOperation {
    @Inject
    private ExpressionLanguage expressionLanguage;

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    protected void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        Preconditions.checkArgument((expressionLanguage != null ? 1 : 0) != 0, (String)"ExpressionLanguage cannot be null");
        this.expressionLanguage = expressionLanguage;
    }

    protected CommonsExpressionLanguage getCommonsExpressionLanguage() {
        return new CommonsExpressionLanguageImpl(this.expressionLanguage);
    }

    protected final <P, A, T> Function<Throwable, T> notifyCompletionCallbackError(CompletionCallback<P, A> completionCallback) {
        return throwable -> {
            Throwable rootCause = throwable;
            if (throwable instanceof CompletionException) {
                rootCause = throwable.getCause();
            }
            if (!(rootCause instanceof ModuleException)) {
                rootCause = this.toUnknownErrorModuleException(rootCause);
            }
            completionCallback.error(rootCause);
            return null;
        };
    }

    protected ModuleException toUnknownErrorModuleException(Throwable throwable) {
        return new ModuleException(I18nMessageFactory.createStaticMessage((String)"Unknown error"), (ErrorTypeDefinition)RestError.CONNECTIVITY, throwable);
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    protected final MediaType resolveDefaultResponseMediaType(RestConfiguration config) {
        return MediaTypeUtils.resolveDefaultResponseMediaType(config.getCharset(), this.getDefaultResponseMediaType());
    }
}

