/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import com.mulesoft.connectivity.rest.commons.internal.http.HttpResponseAttributes;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.OptionalLong;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Preconditions;

public class HttpResponseResult {
    private InputStream entityContent;
    private MediaType mediaType = null;
    private HttpResponseAttributes httpResponseAttributes = null;
    private OptionalLong length = OptionalLong.empty();

    public static Builder builder() {
        return new Builder();
    }

    protected HttpResponseResult() {
    }

    public Builder copy() {
        Builder builder = new Builder().entityContent(this.entityContent);
        builder.httpResponseAttributes(this.httpResponseAttributes);
        builder.mediaType(this.mediaType);
        builder.length(this.getByteLength());
        return builder;
    }

    public InputStream getEntityContent() {
        return this.entityContent;
    }

    public HttpResponseAttributes getHttpResponseAttributes() {
        return this.httpResponseAttributes;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Charset getCharset() {
        return (Charset)this.mediaType.getCharset().get();
    }

    public OptionalLong getByteLength() {
        return this.length;
    }

    public static class Builder {
        private static final byte[] NO_BYTES = new byte[0];
        private final HttpResponseResult product = new HttpResponseResult();

        protected Builder() {
        }

        public Builder entityContent(InputStream entityContent) {
            if (entityContent == null) {
                this.product.entityContent = new ByteArrayInputStream(Builder.NO_BYTES);
            } else {
                this.product.entityContent = entityContent;
            }
            return this;
        }

        public Builder httpResponseAttributes(HttpResponseAttributes httpResponseAttributes) {
            this.product.httpResponseAttributes = httpResponseAttributes;
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            Preconditions.checkArgument((boolean)mediaType.getCharset().isPresent(), (String)"'defaultResponseMediaType' should have a charset defined");
            this.product.mediaType = mediaType;
            return this;
        }

        public Builder length(OptionalLong length) {
            this.product.length = length;
            return this;
        }

        public HttpResponseResult build() {
            Objects.requireNonNull(this.product.entityContent, "entityContent cannot be null");
            Objects.requireNonNull(this.product.mediaType, "mediaType cannot be null");
            Objects.requireNonNull(this.product.httpResponseAttributes, "httpResponseAttributes cannot be null");
            return this.product;
        }
    }
}

