/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseResult;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public abstract class RestPagingProvider<C extends RestConnection>
implements PagingProvider<C, TypedValue<String>> {
    private final MediaType defaultResponseMediaType;
    private final Function<C, HttpRequestBuilder> requestFactory;
    private boolean stopPaging = false;
    private final PagingStrategy pagingStrategy;

    public RestPagingProvider(Function<C, HttpRequestBuilder> requestFactory, MediaType defaultResponseMediaType, PagingStrategy pagingStrategy) {
        this.requestFactory = requestFactory;
        this.defaultResponseMediaType = defaultResponseMediaType;
        this.pagingStrategy = pagingStrategy;
    }

    public final List<TypedValue<String>> getPage(C connection) {
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        HttpRequestBuilder requestBuilder = this.requestFactory.apply(connection);
        requestBuilder = this.pagingStrategy.configureRequest(connection.getBaseUri(), requestBuilder, () -> this.stopPaging());
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        HttpResponseResult result = this.send(connection, requestBuilder, this.defaultResponseMediaType);
        TypedValue<String> rawPage = this.toRawPage(result.getEntityContent(), result.getMediaType());
        if (StringUtils.isBlank((String)((String)rawPage.getValue())) || this.stopPaging) {
            return Collections.emptyList();
        }
        List<TypedValue<String>> page = this.extractPageItems(this.postProcess(rawPage));
        this.pagingStrategy.onPage(page, rawPage, result.getHttpResponseAttributes().getHeaders(), () -> this.stopPaging());
        return page;
    }

    protected abstract TypedValue<String> toRawPage(InputStream var1, MediaType var2);

    protected HttpResponseResult send(C connection, HttpRequestBuilder requestBuilder, MediaType defaultResponseMediaType) {
        try {
            return connection.send(requestBuilder.build(), defaultResponseMediaType);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    protected abstract List<TypedValue<String>> extractPageItems(TypedValue<String> var1);

    protected TypedValue<String> postProcess(TypedValue<String> rawPage) {
        return rawPage;
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
    }

    private void stopPaging() {
        this.stopPaging = true;
    }

    public static interface PagingContext {
        public void stopPaging();
    }
}

