/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy;

import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PagingStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.RestUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class OffsetPagingStrategy
implements PagingStrategy {
    private final String offsetParamName;
    private int offset;

    public OffsetPagingStrategy(String offsetParamName, int initialOffset) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)offsetParamName), (String)"offsetParamName cannot be blank");
        this.offsetParamName = offsetParamName;
        this.offset = initialOffset;
    }

    @Override
    public final HttpRequestBuilder configureRequest(String baseUri, HttpRequestBuilder requestBuilder, RestPagingProvider.PagingContext context) {
        requestBuilder.addQueryParam(this.offsetParamName, RestUtils.stringValue(this.offset));
        return requestBuilder;
    }

    @Override
    public final void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, MultiMap<String, String> headers, RestPagingProvider.PagingContext context) {
        this.offset += page.size();
    }
}

