/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.source;

import com.mulesoft.connectivity.rest.commons.api.error.SourceStartingException;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSourceStrategy;
import com.mulesoft.connectivity.rest.commons.internal.util.SplitPayloadUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.source.PollContext;

public abstract class BaseDataWeaveBasedRestPollingSourceStrategy<S extends Serializable, A>
implements RestPollingSourceStrategy<S, A> {
    protected final String watermarkExpression;
    protected final String identityExpression;
    protected final String itemsExpression;
    protected final String itemBinding;
    private final ExpressionLanguage expressionLanguage;
    private final Class<S> watermarkDataType;

    public BaseDataWeaveBasedRestPollingSourceStrategy(String itemsExpression, String identityExpression, String watermarkExpression, String itemBinding, ExpressionLanguage expressionLanguage, Class<S> watermarkDataType) throws SourceStartingException {
        this.watermarkExpression = watermarkExpression;
        this.identityExpression = identityExpression;
        this.itemsExpression = itemsExpression;
        this.itemBinding = itemBinding;
        this.expressionLanguage = expressionLanguage;
        this.watermarkDataType = watermarkDataType;
        this.validateExpressionsAndArguments();
    }

    private void validateExpressionsAndArguments() throws SourceStartingException {
        Preconditions.checkArgument((!StringUtils.isBlank((String)this.watermarkExpression) ? 1 : 0) != 0, (String)"watermarkExpression must not be null or blank");
        Preconditions.checkArgument((!StringUtils.isBlank((String)this.itemsExpression) ? 1 : 0) != 0, (String)"itemsExpression must not be null or blank");
        Preconditions.checkArgument((!StringUtils.isBlank((String)this.identityExpression) ? 1 : 0) != 0, (String)"identityExpression must not be null or blank");
        Preconditions.checkArgument((!StringUtils.isBlank((String)this.itemBinding) ? 1 : 0) != 0, (String)"itemBinding expression must not be null or blank, suggested expression: 'item'");
        Preconditions.checkArgument((!Objects.isNull(this.expressionLanguage) ? 1 : 0) != 0, (String)"expressionLanguage must not be null");
        Preconditions.checkArgument((!Objects.isNull(this.watermarkDataType) ? 1 : 0) != 0, (String)"watermarkDataType must not be null");
        this.validateExpression(this.watermarkExpression);
        this.validateExpression(this.identityExpression);
        this.validateExpression(this.itemsExpression);
    }

    private void validateExpression(String expression) throws SourceStartingException {
        ValidationResult validationResult = this.expressionLanguage.validate(expression);
        if (!validationResult.isSuccess()) {
            throw new SourceStartingException(String.format("Expression is not valid: %s", expression));
        }
    }

    @Override
    public S getItemWatermark(Optional<S> lastWatermark, TypedValue<String> payload, TypedValue<String> item) {
        return (S)((Serializable)this.expressionLanguage.evaluate(this.watermarkExpression, DataType.fromType(this.watermarkDataType), this.getDefaultBindingContextBuilder(payload, lastWatermark, Optional.of(item))).getValue());
    }

    @Override
    public String getItemIdentity(Optional<S> lastWatermark, TypedValue<String> payload, TypedValue<String> item) {
        return (String)this.expressionLanguage.evaluate(this.identityExpression, DataType.STRING, this.getDefaultBindingContextBuilder(payload, lastWatermark, Optional.of(item))).getValue();
    }

    @Override
    public List<TypedValue<String>> extractItems(Optional<S> lastWatermark, TypedValue<String> fullResponse, int statusCode, String reasonPhrase, MultiMap<String, String> headers) {
        TypedValue items = this.expressionLanguage.evaluate(this.itemsExpression, fullResponse.getDataType(), this.getDefaultBindingContextBuilder(fullResponse, lastWatermark, Optional.empty()));
        ArrayList<TypedValue<String>> splitList = new ArrayList<TypedValue<String>>();
        SplitPayloadUtils.split(this.expressionLanguage, items).forEachRemaining(item -> splitList.add(new TypedValue((Object)item.getValue().toString(), item.getDataType())));
        return splitList;
    }

    @Override
    public Function<PollContext<InputStream, A>, Optional<S>> getLastWatermark() {
        return pollContext -> pollContext.getWatermark();
    }

    private BindingContext getDefaultBindingContextBuilder(TypedValue<?> payload, Optional<S> lastWatermark, Optional<TypedValue<String>> item) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", payload).addBinding("watermark", new TypedValue(lastWatermark, DataType.fromType(this.watermarkDataType)));
        if (item.isPresent()) {
            builder.addBinding(this.itemBinding, item.get());
        }
        return builder.build();
    }
}

