/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.dw;

import com.mulesoft.connectivity.rest.commons.api.dw.CommonsBindingContext;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguageValue;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;

public class CommonsBindingContextBuilder
implements CommonsBindingContext.Builder {
    private final BindingContext.Builder builder = BindingContext.builder();

    @Override
    public CommonsBindingContextBuilder addContent(String identifier, InputStream value, MediaType mediaType) {
        Preconditions.checkArgument((boolean)mediaType.getCharset().isPresent(), (String)"'mediaType' should have a charset defined");
        return this.addBinding(identifier, value, DataType.builder().type(InputStream.class).mediaType(mediaType).build());
    }

    @Override
    public CommonsBindingContextBuilder addJson(String identifier, InputStream value, Charset charset) {
        return this.addBinding(identifier, value, DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_JSON.withCharset(charset)).build());
    }

    @Override
    public CommonsBindingContextBuilder addJson(String identifier, CommonsExpressionLanguageValue value) {
        return this.addBinding(identifier, value.asString(), DataType.JSON_STRING);
    }

    @Override
    public CommonsBindingContextBuilder addXml(String identifier, InputStream value, Charset charset) {
        return this.addBinding(identifier, value, DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_XML.withCharset(charset)).build());
    }

    @Override
    public CommonsBindingContextBuilder addXml(String identifier, CommonsExpressionLanguageValue value) {
        return this.addBinding(identifier, value.asString(), DataType.XML_STRING);
    }

    @Override
    public CommonsBindingContextBuilder addJava(String identifier, Object value) {
        DataType object = DataType.fromObject((Object)value);
        return this.addBinding(identifier, value, object);
    }

    @Override
    public CommonsBindingContext build() {
        return new CommonsBindingContextImpl(this.builder.build());
    }

    private CommonsBindingContextBuilder addBinding(String identifier, Object value, DataType dataType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)identifier), (String)"Binding identifier cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Binding value cannot be null");
        Preconditions.checkArgument((dataType != null ? 1 : 0) != 0, (String)"Binding dataType cannot be null");
        TypedValue typedValue = new TypedValue(value, dataType);
        this.builder.addBinding(identifier, typedValue);
        return this;
    }

    private class CommonsBindingContextImpl
    implements CommonsBindingContext {
        private final BindingContext bindingContext;

        private CommonsBindingContextImpl(BindingContext bindingContext) {
            this.bindingContext = bindingContext;
        }

        @Override
        public BindingContext bindingContext() {
            return this.bindingContext;
        }
    }
}

