/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.dw;

import com.mulesoft.connectivity.rest.commons.api.dw.CommonsBindingContext;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguage;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguageValue;
import com.mulesoft.connectivity.rest.commons.internal.util.AutoCloseableCursorProviderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;

public class CommonsExpressionLanguageImpl
implements CommonsExpressionLanguage {
    private ExpressionLanguage expressionLanguage;

    public CommonsExpressionLanguageImpl(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public CommonsExpressionLanguageValue evaluateJson(String expression, CommonsBindingContext commonsBindingContext) {
        return this.evaluate(expression, commonsBindingContext, DataType.JSON_STRING);
    }

    @Override
    public CommonsExpressionLanguageValue evaluateXml(String expression, CommonsBindingContext commonsBindingContext) {
        return this.evaluate(expression, commonsBindingContext, DataType.XML_STRING);
    }

    @Override
    public String evaluateAsJavaString(String expression, CommonsBindingContext commonsBindingContext) {
        return (String)this.evaluateJava(expression, commonsBindingContext, DataType.STRING);
    }

    @Override
    public Boolean evaluateAsJavaBoolean(String expression, CommonsBindingContext commonsBindingContext) {
        return (Boolean)this.evaluateJava(expression, commonsBindingContext, DataType.BOOLEAN);
    }

    @Override
    public Number evaluateAsJavaNumber(String expression, CommonsBindingContext commonsBindingContext) {
        return (Number)this.evaluateJava(expression, commonsBindingContext, DataType.NUMBER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommonsExpressionLanguageValue evaluate(String expression, CommonsBindingContext commonsBindingContext, DataType dataType) {
        TypedValue typedValue = this.expressionLanguage.evaluate(expression, dataType, commonsBindingContext.bindingContext());
        CursorStreamProvider cursorStreamProvider = (CursorStreamProvider)typedValue.getValue();
        try (AutoCloseableCursorProviderInputStream autoCloseableCursorProviderInputStream = new AutoCloseableCursorProviderInputStream(cursorStreamProvider);){
            String result = IOUtils.toString((InputStream)autoCloseableCursorProviderInputStream, (Charset)((Charset)typedValue.getDataType().getMediaType().getCharset().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error parsing ExpressionLanguage Response")))));
            CommonsExpressionLanguageValue commonsExpressionLanguageValue = new CommonsExpressionLanguageValue(result);
            return commonsExpressionLanguageValue;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"There was an error either reading the evaluated input stream or closing it"), (Throwable)e);
        }
    }

    private <C> C evaluateJava(String expression, CommonsBindingContext commonsBindingContext, DataType dataType) {
        TypedValue evaluate = this.expressionLanguage.evaluate(expression, dataType, commonsBindingContext.bindingContext());
        return (C)evaluate.getValue();
    }
}

