/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.runtime.core.api.util.StringUtils;

public class RestObjectHandler
implements SchemaHandler {
    public static final String PROPERTY_ORDER = "propertyOrder";
    public static final String CUSTOM_JSON_PROPERTY_PREFIX = "x-";
    private static final String SEPARATOR_CHARS = " -_.?!$%";

    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ObjectSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        ObjectSchema objectSchema = (ObjectSchema)schema;
        ObjectTypeBuilder objectMetadataBuilder = root.objectType().ordered(true);
        parsingContext.registerBuilder((Schema)objectSchema, (TypeBuilder<?>)objectMetadataBuilder);
        String id = objectSchema.getId();
        if (!StringUtils.isBlank((String)id)) {
            objectMetadataBuilder.id(id);
        }
        this.getObjectLabel(objectSchema).ifPresent(arg_0 -> ((ObjectTypeBuilder)objectMetadataBuilder).label(arg_0));
        List<Map.Entry<String, Schema>> orderedProperties = this.getOrderedProperties(objectSchema);
        List requiredProperties = objectSchema.getRequiredProperties();
        for (Map.Entry<String, Schema> property : orderedProperties) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField().key(property.getKey());
            this.processSchemaProperty(handlerManager, parsingContext, requiredProperties, property, field);
        }
        Map patternProperties = objectSchema.getPatternProperties();
        Collection entries = patternProperties.entrySet().stream().sorted(Comparator.comparing(o -> ((Pattern)o.getKey()).toString())).collect(Collectors.toList());
        for (Map.Entry patternSchemaEntry : entries) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField();
            field.key((Pattern)patternSchemaEntry.getKey());
            Schema value = (Schema)patternSchemaEntry.getValue();
            field.value(handlerManager.handle(value, parsingContext));
        }
        if (objectSchema.permitsAdditionalProperties()) {
            objectMetadataBuilder.openWith(handlerManager.handle(objectSchema.getSchemaOfAdditionalProperties(), parsingContext));
        }
        return objectMetadataBuilder;
    }

    protected void processSchemaProperty(RestHandlerManager handlerManager, ParsingContext parsingContext, List<String> requiredProperties, Map.Entry<String, Schema> property, ObjectFieldTypeBuilder field) {
        field.required(requiredProperties.contains(property.getKey()));
        Schema value = property.getValue();
        field.value(handlerManager.handle(value, parsingContext));
        RestObjectHandler.optional(() -> this.getFieldLabel((String)property.getKey(), (Schema)property.getValue()), () -> this.inferFieldLabel((String)property.getKey(), (Schema)property.getValue())).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)field).label(arg_0));
        RestObjectHandler.optional(() -> this.getFieldDescription((String)property.getKey(), (Schema)property.getValue()), () -> this.inferFieldDescription((String)property.getKey(), (Schema)property.getValue())).ifPresent(arg_0 -> ((ObjectFieldTypeBuilder)field).description(arg_0));
    }

    public static <T> Optional<T> optional(Supplier<Optional<T>> optional1Supplier, Supplier<Optional<T>> optional2Supplier) {
        Optional<T> optional = optional1Supplier.get();
        return optional.isPresent() ? optional : optional2Supplier.get();
    }

    public static Optional<String> nonBlank(String text) {
        return Optional.ofNullable(!StringUtils.isBlank((String)text) ? text : null);
    }

    protected Optional<String> getObjectLabel(ObjectSchema objectSchema) {
        return RestObjectHandler.nonBlank(objectSchema.getTitle());
    }

    protected Optional<String> getFieldLabel(String id, Schema property) {
        return RestObjectHandler.nonBlank(property.getTitle());
    }

    protected Optional<String> inferFieldLabel(String id, Schema property) {
        return RestObjectHandler.nonBlank(this.titleCase(id));
    }

    protected Optional<String> getFieldDescription(String id, Schema property) {
        return RestObjectHandler.nonBlank(property.getDescription());
    }

    protected Optional<String> inferFieldDescription(String id, Schema property) {
        return RestObjectHandler.optional(() -> RestObjectHandler.nonBlank(property.getTitle()), () -> RestObjectHandler.nonBlank(id)).map(this::sentenceCase);
    }

    private List<Map.Entry<String, Schema>> getOrderedProperties(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrderArray = this.getPropertyOrder(objectSchema);
        HashMap propertySchemas = new HashMap(objectSchema.getPropertySchemas());
        if (propertyOrderArray == null) {
            return new ArrayList<Map.Entry<String, Schema>>(propertySchemas.entrySet());
        }
        ArrayList<Map.Entry<String, Schema>> result = new ArrayList<Map.Entry<String, Schema>>();
        for (Object propertyOrderItem : propertyOrderArray) {
            String key;
            Schema schema;
            if (!(propertyOrderItem instanceof String) || (schema = (Schema)propertySchemas.get(key = (String)propertyOrderItem)) == null) continue;
            propertySchemas.remove(key);
            result.add(new AbstractMap.SimpleEntry<String, Schema>(key, schema));
        }
        result.addAll(propertySchemas.entrySet());
        return result;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrder = this.getPropertyOrder(objectSchema, PROPERTY_ORDER);
        if (propertyOrder == null) {
            propertyOrder = this.getPropertyOrder(objectSchema, "x-propertyOrder");
        }
        return propertyOrder;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema, String propertyName) {
        Object propertyOrderObject;
        if (objectSchema.getUnprocessedProperties().containsKey(propertyName) && (propertyOrderObject = objectSchema.getUnprocessedProperties().get(propertyName)) instanceof ArrayList) {
            return (ArrayList)propertyOrderObject;
        }
        return null;
    }

    private String titleCase(String text) {
        return this.textCase(text, true);
    }

    private String sentenceCase(String text) {
        return this.textCase(text, false);
    }

    private String textCase(String text, boolean capitalizeAllWords) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String result = this.camelCaseSeparate(text);
        CharSequence[] words = StringUtils.splitAndTrim((String)result, (String)SEPARATOR_CHARS);
        if (words.length > 0) {
            if (capitalizeAllWords) {
                for (int i = 0; i < words.length; ++i) {
                    words[i] = this.capitalize((String)words[i]);
                }
            } else {
                words[0] = this.capitalize((String)words[0]);
            }
        }
        return String.join((CharSequence)" ", words);
    }

    private String capitalize(String word) {
        if (word == null || word.length() == 0) {
            return word;
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1, word.length());
    }

    private String camelCaseSeparate(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        String result = text.replaceAll("(\\D)(\\d)", "$1 $2").replaceAll("(\\d)(\\D)", "$1 $2").replaceAll("([A-Z])([A-Z])([a-z])", "$1 $2$3").replaceAll("([a-z])([A-Z]+)", "$1 $2").toLowerCase();
        return result;
    }
}

