/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;

public final class RestUtils {
    private RestUtils() {
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            CursorProvider cursorProvider = (CursorProvider)stream;
            cursorProvider.close();
            cursorProvider.releaseResources();
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static TypedValue<String> consumeStringAndClose(Object stream, MediaType targetMediaType, Charset targetCharset) {
        return RestUtils.consumeStringTransformAndClose(stream, targetCharset, targetMediaType, targetCharset);
    }

    public static List<TypedValue<String>> toList(Iterator<TypedValue<?>> iterator) {
        ArrayList<TypedValue<String>> list = new ArrayList<TypedValue<String>>();
        iterator.forEachRemaining(v -> {
            TypedValue<String> stringTypedValue = RestUtils.consumeStringAndClose(v.getValue(), v.getDataType().getMediaType(), (Charset)v.getDataType().getMediaType().getCharset().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Charset is required in order to process items"))));
            list.add(stringTypedValue);
        });
        return list;
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer | o instanceof Long | o instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(o);
        }
        return String.valueOf(o);
    }

    private static TypedValue<String> consumeStringTransformAndClose(Object stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        Either content;
        if (stream == null) {
            return RestUtils.toTypedValue("", targetMediaType, targetCharset);
        }
        if (stream instanceof String) {
            return RestUtils.toTypedValue((String)stream, targetMediaType, targetCharset);
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (TypedValue)content.reduce(provider -> {
            try {
                TypedValue<String> typedValue = RestUtils.doConsumeAndClose((InputStream)provider.openCursor(), sourceCharset, targetMediaType, targetCharset);
                return typedValue;
            }
            finally {
                RestUtils.closeStream(provider);
            }
        }, in -> RestUtils.doConsumeAndClose(in, sourceCharset, targetMediaType, targetCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedValue<String> doConsumeAndClose(InputStream stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        try {
            TypedValue<String> typedValue = RestUtils.toTypedValue(IOUtils.toString((InputStream)stream, (Charset)sourceCharset), targetMediaType, targetCharset);
            return typedValue;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static TypedValue<String> toTypedValue(String value, MediaType mediaType, Charset encoding) {
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }
}

