/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection.validation;

/**
 * This object represents a condition to be met by a server response in order to consider a connection valid.
 *
 * @since 1.0
 */
public class TestConnectionValidation {

  private final String validationExpression;
  private final String errorTemplateExpression;

  public TestConnectionValidation(String validationExpression, String errorTemplateExpression) {
    this.validationExpression = validationExpression;
    this.errorTemplateExpression = errorTemplateExpression;
  }

  public String getValidationExpression() {
    return validationExpression;
  }

  public String getErrorTemplateExpression() {
    return errorTemplateExpression;
  }
}
