/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * Allows to declare and build the body of a multipart request
 *
 * @since 1.0
 */
public interface MultipartPayloadBuilder {

  /**
   * Adds a simple type
   *
   * @param partName the part name
   * @param content  the part content
   * @return {@code this} builder
   */
  MultipartPayloadBuilder addPart(String partName, TypedValue<InputStream> content);

  /**
   * Adds a part which carries an attachment file
   *
   * @param partName the part name
   * @param filename the file's name
   * @param content  the file's content
   * @return {@code this} builder
   */
  MultipartPayloadBuilder addFilePart(String partName, String filename, TypedValue<InputStream> content);

  /**
   * Allows to specify the boundary that will separate the parts
   *
   * @param boundary the boundary
   * @return {@code this} builder
   */
  MultipartPayloadBuilder setBoundary(String boundary);

  /**
   * Returns the built body as an {@link InputStream}
   *
   * @return the built body
   */
  TypedValue<InputStream> build();

}
