/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Set;

import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;

public class EnumHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof EnumSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager,
                               ParsingContext parsingContext) {
    final EnumSchema enumSchema = (EnumSchema) schema;
    final StringTypeBuilder enumMetadataBuilder = root.stringType();
    final Set<Object> possibleValues = enumSchema.getPossibleValues();
    final String[] stringValues = possibleValues.stream().map((v) -> String.valueOf(v)).toArray(String[]::new);
    enumMetadataBuilder.enumOf(stringValues);
    if (schema.getId() != null) {
      enumMetadataBuilder.id(schema.getId());
    }
    return enumMetadataBuilder;
  }
}
