/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import static org.mule.metadata.api.utils.MetadataTypeUtils.isNotNull;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class StringHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof StringSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager,
                               ParsingContext parsingContext) {
    final StringSchema stringSchema = (StringSchema) schema;
    final StringTypeBuilder stringType = root.stringType();

    Integer min = null;
    Integer max = null;

    if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0) {
      min = stringSchema.getMinLength();
    }

    if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0) {
      max = stringSchema.getMaxLength();
    }
    if (isNotNull(min) || isNotNull(max)) {
      stringType.boundary(min, max);
    }

    if (stringSchema.getPattern() != null) {
      stringType.pattern(stringSchema.getPattern().toString());
    }
    return stringType;
  }
}
