/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static org.mule.runtime.core.api.util.IOUtils.closeQuietly;

import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

import java.io.Closeable;

/**
 * A {@link CompletionCallbackDecorator} which makes sure that a given {@link #closeable} is always closed
 * upon completion
 *
 * @param <T> the generic payload type
 * @param <A> the generic attributes type
 * @since 1.0
 */
public class CloserCompletionCallbackDecorator<T, A> extends CompletionCallbackDecorator<T, A> {

  private final Closeable closeable;

  public CloserCompletionCallbackDecorator(CompletionCallback<T, A> delegate,
                                           Closeable closeable) {
    super(delegate);
    this.closeable = closeable;
  }

  @Override
  public void success(Result<T, A> result) {
    try {
      super.success(result);
    } finally {
      closeQuietly(closeable);
    }
  }

  @Override
  public void error(Throwable throwable) {
    try {
      super.error(throwable);
    } finally {
      closeQuietly(closeable);
    }
  }
}
