/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.resolver.output.dynamic;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.loadXmlSchema;
import org.mule.metadata.api.model.MetadataType;

/**
 * {@link SchemaOutputDynamicMetadataResolver} that loads an XML schema
 *
 * @since 1.0
 */
public abstract class XmlOutputDynamicMetadataResolver extends SchemaOutputDynamicMetadataResolver {

  @Override
  protected MetadataType loadSchema(String schemaPath) {
    return loadXmlSchema(getClass().getClassLoader(), schemaPath, getQName());
  }

  /**
   * @return the QName for the loaded XML type
   */
  protected abstract String getQName();
}
